﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="BioContactFollowups.aspx.cs" Inherits="BioContactFollowups" MasterPageFile ="~/Registry.master"  %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
    <link type = "text/css" href = "styles/StyleSheet.css" />
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();

        });
    </script>
    
    <div class="breadcrumb">
        
        <asp:Label ID = "BreadCrumbLabel" runat="server" Text= "My Tasks > Referrals > Follow Ups"  />
             
    </div>
    <br />
    <div class = "excludeSaveWarnings">
    <asp:Label ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Last Name:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Clear"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        
     </div>
     <br />
     <asp:GridView ID = "GridViewReferralFollowUps" runat = "server" DataSourceID = "ObjectDataSourceFollowUps" AutoGenerateColumns = "false"
    AllowPaging="True" PageSize="20" DataKeyNames = "ReferralId, ContactId" OnRowCommand = "FollowUps_RowCommand" AllowSorting = "true" >
       <EmptyDataTemplate>
            No followups exist for any referrals
       </EmptyDataTemplate> 
        
        <Columns>
        
            <asp:TemplateField HeaderText = "Referral Number" SortExpression = "ReferralId" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelRefID" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ReferralId")), false) %>' ></asp:Label> 
                
                </ItemTemplate> 
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Patient Name" SortExpression = "PatientLastName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelPatientName" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("PatientFullName")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Site Number" SortExpression="StationNumber">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelStationNumber" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("StationNumber")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
           
            <asp:TemplateField HeaderText="Facility" SortExpression="InstitutionName">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelInstitution" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("InstitutionName")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="Reason" SortExpression = "Reason">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReason" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("Reason")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Due Date" SortExpression = "DueDate">
                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelDueDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NormalizedDueDate")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
                                             
            <asp:TemplateField HeaderText="Remind Me On" SortExpression = "ReminderDate">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelReminderDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NormalizedReminderDate")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="" SortExpression = "FollowUpType" Visible = "false">
                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelFollowupType" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("FollowUpType")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" AccessibleHeaderText = "Select"  />
            
        </Columns>
    </asp:GridView>    
     
    <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />    
    <asp:ObjectDataSource ID="ObjectDataSourceFollowUps" runat="server" 
            SelectMethod="SelectAll" 
            SelectCountMethod="SelectAllCount" 
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True" 
            TypeName="VeteransAffairs.Registries.BusinessManager.FollowupManager">
            <SelectParameters>
            <asp:ControlParameter Name = "searchValue" ControlID = "TextBoxSearchCriteria" DefaultValue = "" />  
                
            </SelectParameters>        
   </asp:ObjectDataSource>
</asp:Content>
